package com.example.testj.utils;

import org.springframework.stereotype.Service;

import com.example.testj.domain.Goods;
import com.example.testj.domain.Order;
import com.example.testj.domain.OrderLine;
import com.example.testj.service.dto.GoodsDto;
import com.example.testj.service.dto.OrderDto;
import com.example.testj.service.dto.OrderLineDto;

@Service
public class MappingUtils {
    public OrderDto toOrderDto(Order order) {
        return new OrderDto(order);
    }

    public Order toOrder(OrderDto orderDto) {
        Order order = new Order();
        order.setId(orderDto.getId());
        order.setClient(orderDto.getClient());
        order.setDate(orderDto.getDate());
        order.setAddress(orderDto.getAddress());
        order.setOrderLines(orderDto.getOrderLines());
        return order;
    }

    public OrderLineDto toOrderLineDto(OrderLine orderLine) {
        return new OrderLineDto(orderLine);
    }

    public OrderLine toOrderLine(OrderLineDto orderLineDto) {
        OrderLine orderLine = new OrderLine();
        orderLine.setGoods(orderLineDto.getGoods());
        orderLine.setOrder(orderLineDto.getOrder());
        orderLine.setCount(orderLineDto.getCount());
        return orderLine;
    }

    public GoodsDto toGoodsDto(Goods goods) {
        return new GoodsDto(goods);
    }

    public Goods toGoods(GoodsDto goodsDto) {
        Goods goods = new Goods();
        goods.setId(goodsDto.getId());
        goods.setName(goodsDto.getName());
        goods.setPrice(goodsDto.getPrice());
        return goods;
    }
}
