import { Component, EventEmitter, Input, Output } from '@angular/core';
import { Goods } from '../../../../core/model/goods.model';
import { PageModel } from '../../../../core/model/paged-response.model';

@Component({
  selector: 'app-goods-list',
  templateUrl: './goods-list.component.html',
  styleUrl: './goods-list.component.scss',
})
export class GoodsListComponent {
  @Input() goods!: Goods[];
  @Input() page!: PageModel;
  @Output() pageNumber = new EventEmitter<number>();

  @Output() openModal = new EventEmitter<Goods>();
  @Output() delete = new EventEmitter<number>();

  pageNumberChange(page: number) {
    this.pageNumber.emit(page);
  }

  openEdit(product: Goods) {
    this.openModal.emit(product);
  }

  deleteProduct(id: number) {
    this.delete.emit(id);
  }
}
