package com.example.testj.service;

import org.springframework.stereotype.Service;

import com.example.testj.domain.OrderLine;
import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.repository.OrderLineRepository;
import com.example.testj.service.dto.OrderLineDto;
import com.example.testj.utils.MappingUtils;

@Service
public class OrderLineService {
    private final MappingUtils mappingUtils;
    private final OrderLineRepository orderLineRepository;

    public OrderLineService(OrderLineRepository orderLineRepository, MappingUtils mappingUtils) {
        this.orderLineRepository = orderLineRepository;
        this.mappingUtils = mappingUtils;
    }

    public OrderLineDto createOrUpdateOrderLine(OrderLine orderLine) {
        return mappingUtils.toOrderLineDto(orderLineRepository.save(orderLine));
    }

    public OrderLineDto getOrderLine(Long id) throws ResourceNotFoundException {
        return mappingUtils.toOrderLineDto(orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new));
    }

    public void deleteOrderLine(Long id) {
        orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        orderLineRepository.deleteById(id);
    }
}
