package com.example.testj.web.rest;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.testj.service.OrderLineService;
import com.example.testj.service.dto.OrderLineDto;
import com.example.testj.utils.MappingUtils;

import jakarta.validation.Valid;

@RestController
@RequestMapping("/api/order-line")
@CrossOrigin(origins = "http://localhost:4200")
public class OrderLineController {
    private final OrderLineService orderLineService;
    private final MappingUtils mappingUtils;

    public OrderLineController(OrderLineService orderLineService, MappingUtils mappingUtils) {
        this.orderLineService = orderLineService;
        this.mappingUtils = mappingUtils;
    }

    @GetMapping("/{id}")
    public OrderLineDto get(@PathVariable Long id) {
        return orderLineService.getOrderLine(id);
    }

    @PostMapping
    public OrderLineDto createOrder(@Valid @RequestBody OrderLineDto orderLine) {
        return orderLineService.createOrUpdateOrderLine(mappingUtils.toOrderLine(orderLine));
    }

    @PutMapping("/{id}")
    public OrderLineDto updateOrder(@PathVariable Long id, @Valid @RequestBody OrderLineDto orderLine) {
        OrderLineDto updateOrderLine = orderLineService.getOrderLine(id);
        updateOrderLine.setCount(orderLine.getCount());
        return orderLineService.createOrUpdateOrderLine(mappingUtils.toOrderLine(updateOrderLine));
    }

}
