import { Component, EventEmitter, Input, Output } from '@angular/core';
import { Order } from '../../../../core/model/order.model';
import { PageModel } from '../../../../core/model/paged-response.model';

@Component({
  selector: 'app-orders-list',
  templateUrl: './orders-list.component.html',
  styleUrl: './orders-list.component.scss',
})
export class OrdersListComponent {
  @Input() orders!: Order[];
  @Input() page!: PageModel;
  @Output() pageNumber = new EventEmitter<number>();

  @Output() openModal = new EventEmitter<Order>();
  @Output() delete = new EventEmitter<number>();

  pageNumberChange(page: number) {
    this.pageNumber.emit(page);
  }

  openOrder(order: Order) {
    this.openModal.emit(order);
  }

  deleteOrder(id: number) {
    this.delete.emit(id);
  }
}
