import { Component, EventEmitter, Input, Output } from '@angular/core';
import { NgbModal, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { Goods } from '../../../../core/model/goods.model';
import { AbstractBasicComponent } from '../../../../core/abstract/abstract-component';
import { takeUntil } from 'rxjs';
import { PagedResponseModel } from '../../../../core/model/paged-response.model';
import { Order } from '../../../../core/model/order.model';
import { UpdateCount } from '../../order-page.component';

@Component({
  selector: 'app-add-product-modal',
  templateUrl: './add-product-modal.component.html',
  styleUrl: './add-product-modal.component.scss',
})
export class AddProductModalComponent extends AbstractBasicComponent {
  @Input() goods!: PagedResponseModel<Goods>;
  @Input() order!: Order;
  @Output() pageNumber = new EventEmitter<number>();
  @Output() orderLineChange = new EventEmitter<UpdateCount>();

  modal: NgbModalRef | undefined;

  constructor(modalService: NgbModal) {
    super();

    modalService.activeInstances
      .pipe(takeUntil(this.destroy$))
      .subscribe((mls) => {
        this.modal = mls[mls.length - 1];
      });
  }

  addOrUpdate(goods_id: number, count: number) {
    this.orderLineChange.emit({
      goods_id,
      count,
    });
  }

  productsCount(productId: number): number {
    return (
      this.order.orderLines.find((ol) => ol.goods.id === productId)?.count ?? 0
    );
  }

  pageNumberChange(page: number) {
    this.pageNumber.emit(page);
  }
}
