package com.example.testj.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.*;
import jakarta.validation.constraints.Min;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.format.annotation.NumberFormat;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "order_line")
public class OrderLine {
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;

    @JsonIgnoreProperties(value = "orderLines")
    @ManyToOne
    @JoinColumn(name = "order_id")
    private Order order;

    @JsonIgnoreProperties(value = "orderLines")
    @ManyToOne
    @JoinColumn(name = "goods_id")
    private Goods goods;

    @NumberFormat
    @Min(1)
    @Column(name = "count")
    private int count;
}
