package com.example.testj.exception;

import lombok.Getter;
import lombok.Setter;
import org.springframework.http.HttpStatusCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Getter
@Setter
public class ApiError {

    private final Date timestamp;
    private HttpStatusCode status;
    private String message;
    private List<Map<String, String>> errors;

    public ApiError() {
        timestamp = new Date();
    }

    public ApiError(HttpStatusCode status, String message, List<Map<String, String>> errors) {
        super();
        timestamp = new Date();
        this.status = status;
        this.message = message;
        this.errors = errors;
    }

    public ApiError(HttpStatusCode status, String message, String error) {
        super();
        timestamp = new Date();
        this.status = status;
        this.message = message;
        errors = List.of(Map.of("message", error));
    }
}