import { HttpClient, HttpErrorResponse } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { catchError, EMPTY } from 'rxjs';
import { environment } from '../../../environments/environment';
import {
  OrderLineCreateReq,
  OrderLineUpdateReq,
} from '../model/order-line.model';

@Injectable({
  providedIn: 'root',
})
export class OrderLineService {
  private readonly apiUrl = `${environment.API_ROOT}${environment.API_PREFIX}${environment.ORDER_LINE_URL}`;

  constructor(private http: HttpClient) {}

  put(id: number, req: OrderLineUpdateReq) {
    const url = `${this.apiUrl}/${id}`;
    return this.http.put<OrderLineUpdateReq>(url, req);
  }

  post(req: OrderLineCreateReq) {
    const url = this.apiUrl;
    return this.http.post<OrderLineCreateReq>(url, req);
  }

  delete(id: number) {
    const url = `${this.apiUrl}/${id}`;
    return this.http.delete(url).pipe(
      catchError((err: HttpErrorResponse) => {
        console.dir(err);
        return EMPTY;
      }),
    );
  }
}
