import { Component, EventEmitter, Input, Output } from '@angular/core';
import { NgbModal, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { takeUntil } from 'rxjs';
import { AbstractBasicComponent } from '../../../../core/abstract/abstract-component';
import { Order } from '../../../../core/model/order.model';

@Component({
  selector: 'app-order-edit-modal',
  templateUrl: './order-edit-modal.component.html',
  styleUrl: './order-edit-modal.component.scss',
})
export class OrderEditModalComponent extends AbstractBasicComponent {
  @Input() order!: Order;
  @Output() orderChange = new EventEmitter<Order>();

  modal!: NgbModalRef;

  constructor(modalService: NgbModal) {
    super();

    modalService.activeInstances
      .pipe(takeUntil(this.destroy$))
      .subscribe((mls) => {
        this.modal = mls[mls.length - 1];
      });
  }

  orderChanged(order: Order) {
    this.orderChange.emit(order);
    this.modal.close();
  }
}
