import { Component, EventEmitter, Input, Output } from '@angular/core';
import { OrderLine } from '../../../../core/model/order-line.model';

@Component({
  selector: 'app-order-line-list',
  templateUrl: './order-line-list.component.html',
  styleUrl: './order-line-list.component.scss',
})
export class OrderLineListComponent {
  @Input() orderLines!: OrderLine[];
  @Output() deleteId = new EventEmitter<number>();

  deleteLine(id: number) {
    this.deleteId.emit(id);
  }
}
