package com.example.testj.service.dto;

import jakarta.validation.constraints.NotBlank;
import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * DTO for {@link com.example.testj.domain.Order}
 */
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
@EqualsAndHashCode(exclude = {"orderLines"})
public class OrderDto implements Serializable {
    private Long id;

    @NotBlank
    private String client;

    @NotBlank
    private String date;

    @NotBlank
    private String address;

    private List<OrderLineDto> orderLines;
}