import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { environment } from '../../../../environments/environment';
import { Goods } from '../../../core/model/goods.model';
import { GoodsService } from '../../../core/service/goods.service';

const DEV = !environment.production;

@Component({
  selector: 'app-goods-form',
  templateUrl: './goods-form.component.html',
  styleUrl: './goods-form.component.scss',
})
export class GoodsFormComponent {
  @Input() product!: Goods;
  @Output() productChange = new EventEmitter<Goods>();
  @Output() isUpdate = new EventEmitter<boolean>();

  form: FormGroup;

  constructor(
    fb: FormBuilder,
    private goodsService: GoodsService,
  ) {
    this.form = fb.group({
      name: ['', Validators.required],
      price: ['', Validators.required],
    });
  }

  public get isNew(): boolean {
    return !this.product;
  }

  ngOnInit(): void {
    if (!this.isNew) {
      this.form.setValue({
        name: this.product?.name,
        price: this.product?.price,
      });
    }
  }

  save() {
    if (this.form.valid) {
      if (this.isNew) {
        // Create
        this.goodsService.post({ ...this.form.value }).subscribe({
          next: (res) => {
            this.isUpdate.emit(true);
          },
          error: (err) => {
            if (DEV) {
              console.dir(err);
            }
          },
        });
      } else {
        // Update
        this.goodsService
          .put({ ...this.form.value, id: this.product.id })
          .subscribe({
            next: (res) => {
              this.productChange.emit(res);
              this.isUpdate.emit(true);
            },
            error: (err) => {
              if (DEV) {
                console.dir(err);
              }
            },
          });
      }
    }
  }
}
