package com.example.testj.domain;

import jakarta.persistence.*;
import org.springframework.format.annotation.NumberFormat;

import java.util.Set;

@Entity
@Table(name = "order_line")
public class OrderLine {
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;

    @ManyToOne
    @JoinColumn(name = "order_id", nullable = false)
    private Order order;

    @ManyToOne
    @JoinColumn(name = "goods_id", nullable = false)
    private Goods goods;

    @Column(name = "count")
    @NumberFormat
    private int count;



    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Goods getGoods() {
        return goods;
    }
}
