package com.example.testj.service;

import com.example.testj.domain.Order;
import com.example.testj.dto.OrderDTO;
import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.repository.OrderRepository;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PagedModel;
import org.springframework.stereotype.Service;


@Service
public class OrderService {
    private final OrderRepository orderRepository;

    public OrderService(OrderRepository orderRepository) {
        this.orderRepository = orderRepository;
    }

    public PagedModel<Order> getOrders(Integer page, Integer size, String sortBy, String sortDir) {
        return new PagedModel<Order>(orderRepository.findAll(PageRequest.of(page, size, Sort.by(Sort.Direction.fromString(sortDir), sortBy))));
    }

    public Order getOrder(Long id) throws ResourceNotFoundException {
        return orderRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
    }

    public Order saveOrUpdateOrder(Order order) {
        return orderRepository.save(order);
    }

    public Order patchOrder(Long id, JsonNode patch) throws JsonMappingException {
        Order orderData = orderRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        Order patchedOrder = new ObjectMapper().updateValue(orderData, patch);
        return orderRepository.save(patchedOrder);
    }

    public void deleteOrder(Long id) throws ResourceNotFoundException {
        orderRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        orderRepository.deleteById(id);
    }
}
