package com.example.testj.service;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PagedModel;
import org.springframework.stereotype.Service;

import com.example.testj.domain.Goods;
import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.repository.GoodsRepository;
import com.example.testj.service.dto.GoodsDto;
import com.example.testj.utils.MappingUtils;

@Service
public class GoodsService {
    private final GoodsRepository goodsRepository;
    private final MappingUtils mappingUtils;

    public GoodsService(GoodsRepository goodsRepository, MappingUtils mappingUtils) {
        this.goodsRepository = goodsRepository;
        this.mappingUtils = mappingUtils;
    }

    public PagedModel<GoodsDto> getAllGoods(Integer page, Integer size, String sortBy, String sortDir) {
        return new PagedModel<>(goodsRepository
                .findAll(PageRequest.of(page, size, Sort.by(Sort.Direction.fromString(sortDir), sortBy)))
                .map(mappingUtils::toGoodsDto));
    }

    public GoodsDto getGoods(Long id) {
        return goodsRepository.findById(id).map(mappingUtils::toGoodsDto).orElse(null);
    }

    public GoodsDto createOrUpdate(Goods goods) {
        return mappingUtils.toGoodsDto(this.goodsRepository.save(goods));
    }

    public void deleteGoods(Long id) {
        this.goodsRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        this.goodsRepository.deleteById(id);
    }
}
