package com.example.testj.service;

import org.springframework.stereotype.Service;

import com.example.testj.domain.OrderLine;
import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.repository.OrderLineRepository;
import com.example.testj.service.dto.GoodsDto;
import com.example.testj.service.dto.OrderDto;
import com.example.testj.service.dto.OrderLineDto;
import com.example.testj.service.dto.OrderLineRequestDto;
import com.example.testj.utils.MappingUtils;

@Service
public class OrderLineService {
    private final MappingUtils mappingUtils;
    private final OrderLineRepository orderLineRepository;
    private final OrderService orderService;
    private final GoodsService goodsService;

    public OrderLineService(OrderLineRepository orderLineRepository, MappingUtils mappingUtils,
            OrderService orderService, GoodsService goodsService) {
        this.orderLineRepository = orderLineRepository;
        this.mappingUtils = mappingUtils;
        this.orderService = orderService;
        this.goodsService = goodsService;
    }

    public OrderLineDto createOrderLine(OrderLineRequestDto orderLineRequest) {
        OrderDto order = orderService.getOrder(orderLineRequest.getOrderId());
        GoodsDto goods = goodsService.getGoods(orderLineRequest.getGoodsId());
        OrderLine orderLine = new OrderLine();
        orderLine.setOrder(mappingUtils.toOrder(order));
        orderLine.setGoods(mappingUtils.toGoods(goods));
        orderLine.setCount(orderLineRequest.getCount());

        return mappingUtils.toOrderLineDto(orderLineRepository.save(orderLine));
    }

    public OrderLineDto updateOrderLine(OrderLine orderLine, Long id) {
        OrderLine updatedOrderLine = orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        updatedOrderLine.setCount(orderLine.getCount());
        return mappingUtils.toOrderLineDto(orderLineRepository.save(updatedOrderLine));
    }

    public OrderLineDto getOrderLine(Long id) throws ResourceNotFoundException {
        return mappingUtils
                .toOrderLineDto(orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new));
    }

    public void deleteOrderLine(Long id) {
        orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        orderLineRepository.deleteById(id);
    }
}
