package com.example.testj.exception;

import lombok.Getter;
import lombok.Setter;
import org.springframework.http.HttpStatus;

import java.util.*;

@Getter
@Setter
public class ApiError {

    private final Date timestamp;
    private HttpStatus status;
    private String message;
    private List<Map<String, String>> errors;

    public ApiError() {
        timestamp = new Date();
    }

    public ApiError(HttpStatus status, String message, List<Map<String, String>> errors) {
        super();
        timestamp = new Date();
        this.status = status;
        this.message = message;
        this.errors = errors;
    }

    public ApiError(HttpStatus status, String message, String error) {
        super();
        timestamp = new Date();
        this.status = status;
        this.message = message;
        errors = new ArrayList<>((Collection) Map.of("message", error));

    }
}