package com.example.testj.repository;

import com.example.testj.domain.Goods;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.boot.test.autoconfigure.orm.jpa.TestEntityManager;
import org.springframework.test.context.ActiveProfiles;

import java.util.List;
import java.util.stream.StreamSupport;

import static org.junit.jupiter.api.Assertions.*;

@DataJpaTest
@ActiveProfiles("test")
public class GoodsRepositoryTest {
    @Autowired private GoodsRepository goodsRepository;

    @Autowired private TestEntityManager entityManager;

    @Test
    void testFindById() {
        // given
        Long id = 1L;
        // when
        Goods found = goodsRepository.findById(id).orElse(null);
        // then
        assertNotNull(found);
        assertEquals(id, found.getId());
    }

    @Test
    void testFindByIdNotFound() {
        // given
        Long id = 999L;
        // when
        Goods found = goodsRepository.findById(id).orElse(null);
        // then
        assertNull(found);
    }

    @Test
    @Order(0)
    void testFindAll() {
        // when
        List<Goods> found = StreamSupport.stream(goodsRepository.findAll().spliterator(), false).toList();
        // then
        assertNotNull(found);
        assertEquals(100, found.size());
    }

    @Test
    void testSave() {
        // given
        Goods goods = new Goods();
        goods.setName("new product");
        goods.setPrice(10.99f);
        // when
        Goods inserted = goodsRepository.save(goods);
        // then
        assertNotNull(inserted);
        assertEquals(entityManager.find(Goods.class, inserted.getId()), inserted);
    }

    @Test
    void testUpdate() {
        // given
        Long id = 1L;
        Goods goods = entityManager.find(Goods.class, id);
        goods.setId(id);
        goods.setName("product 2");
        goods.setPrice(1.99f);
        // when
        Goods updated = goodsRepository.save(goods);
        // then
        assertNotNull(updated);
        assertEquals(entityManager.find(Goods.class, updated.getId()), updated);

    }

    @Test
    void testDeleteById() {
        // given
        Long id = 1L;
        // when
        goodsRepository.deleteById(id);
        // then
        assertNull(entityManager.find(Goods.class, id));
    }
}
