package com.example.testj.service;

import com.example.testj.domain.Order;
import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.service.dto.OrderDto;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.data.web.PagedModel;

public interface OrderService {
    PagedModel<OrderDto> getOrdersPaged(Integer page, Integer size, String sortBy, String sortDir);

    OrderDto getOrder(Long id) throws ResourceNotFoundException;

    OrderDto createOrUpdateOrder(Order order);

    OrderDto patchOrder(Long id, JsonNode patch) throws JsonMappingException;

    void deleteOrder(Long id) throws ResourceNotFoundException;
}
