package com.example.testj.service.dto;

import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Positive;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * DTO for {@link com.example.testj.domain.Goods}
 */
@AllArgsConstructor
@Getter
@Setter
public class GoodsDto implements Serializable {
    private final Long id;

    @NotEmpty
    private String name;

    @Min(0L)
    @Digits(integer = 6, fraction = 2)
    @Positive
    private double price;
}