package com.example.testj.service.dto;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * DTO for {@link com.example.testj.domain.Order}
 */
@AllArgsConstructor
@Getter
@Setter
public class OrderDto implements Serializable {
    private final Long id;

    @NotBlank
    private String client;

    private String date;

    @NotBlank
    private String address;

    private List<OrderLineDto> orderLines;
}