package com.example.testj.service.impl;

import com.example.testj.service.GoodsService;
import com.example.testj.service.OrderLineService;
import com.example.testj.service.OrderService;
import com.example.testj.service.mapper.GoodsMapper;
import com.example.testj.service.mapper.OrderLineMapper;
import com.example.testj.service.mapper.OrderMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import com.example.testj.domain.OrderLine;
import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.repository.OrderLineRepository;
import com.example.testj.service.dto.GoodsDto;
import com.example.testj.service.dto.OrderDto;
import com.example.testj.service.dto.OrderLineDto;
import com.example.testj.service.dto.OrderLineRequestDto;

@Service
@RequiredArgsConstructor
public class OrderLineServiceImpl implements OrderLineService {
    private final OrderLineRepository orderLineRepository;
    private final OrderService orderService;
    private final GoodsService goodsService;
    private final OrderLineMapper orderLineMapper;
    private final OrderMapper orderMapper;
    private final GoodsMapper goodsMapper;

    @Override
    public OrderLineDto createOrderLine(OrderLineRequestDto orderLineRequest) {
        OrderDto order = orderService.getOrder(orderLineRequest.getOrderId());
        GoodsDto goods = goodsService.getGoods(orderLineRequest.getGoodsId());
        OrderLine orderLine = new OrderLine();
        orderLine.setOrder(orderMapper.toEntity(order));
        orderLine.setGoods(goodsMapper.toEntity(goods));
        orderLine.setCount(orderLineRequest.getCount());

        return orderLineMapper.toDto(orderLineRepository.save(orderLine));
    }

    @Override
    public OrderLineDto updateOrderLine(OrderLine orderLine, Long id) {
        OrderLine updatedOrderLine = orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        updatedOrderLine.setCount(orderLine.getCount());
        return orderLineMapper.toDto(orderLineRepository.save(updatedOrderLine));
    }

    @Override
    public OrderLineDto getOrderLine(Long id) throws ResourceNotFoundException {
        return orderLineMapper.toDto(orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new));
    }

    @Override
    public void deleteOrderLine(Long id) {
        orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        orderLineRepository.deleteById(id);
    }
}
