import { Subject } from 'rxjs';

import { Injectable, OnDestroy } from '@angular/core';

@Injectable()
export class AbstractBasicComponent implements OnDestroy {
  protected destroy$ = new Subject();

  public ngOnDestroy(): void {
    this.destroy$.next(undefined);
    this.destroy$.complete();
  }
}
