package com.example.testj.repository;

import com.example.testj.domain.Order;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.boot.test.autoconfigure.orm.jpa.TestEntityManager;
import org.springframework.test.context.ActiveProfiles;

import java.util.List;
import java.util.stream.StreamSupport;

import static org.junit.jupiter.api.Assertions.*;

@DataJpaTest
@ActiveProfiles("test")
public class OrderRepositoryTest {
    @Autowired
    private OrderRepository orderRepository;

    @Autowired
    TestEntityManager entityManager;

    @Test
    void testSave() {
        // given
        Order order = new Order();
        order.setClient("Client 1");
        order.setAddress("Address 1");
        order.setDate("2000-01-01");
        // when
        orderRepository.save(order);
        // then
        assertNotNull(order.getId());
        assertEquals(entityManager.find(Order.class, order.getId()).getClient(), order.getClient());
    }

    @Test
    void testFindById() {
        // given
        Long id = 1L;
        // when
        Order found = orderRepository.findById(id).orElse(null);
        // then
        assertNotNull(found);
        assertEquals(found.getId(), id);
    }

    @Test
    void testFindAll() {
        // when
        List<Order> found = StreamSupport.stream(orderRepository.findAll().spliterator(), false).toList();
        // then
        assertNotNull(found);
        assertEquals(100, found.size());
    }

    @Test
    void testUpdate() {
        // given
        Order order = entityManager.find(Order.class, 1L);
        order.setAddress("Address 2");
        order.setClient("Client 2");
        order.setDate("2000-01-01");
        // when
        Order saved = orderRepository.save(order);
        // then
        assertNotNull(saved.getId());
        assertEquals(entityManager.find(Order.class, saved.getId()).getClient(), order.getClient());
    }

    @Test
    void testDelete() {
        // given
        Long id = 2L;
        // when
        orderRepository.deleteById(id);
        // then
        assertNull(entityManager.find(Order.class, id));
    }
}
