package com.example.testj.service;

import com.example.testj.domain.Goods;
import com.example.testj.domain.Order;
import com.example.testj.domain.OrderLine;
import com.example.testj.repository.OrderLineRepository;
import com.example.testj.service.dto.*;
import com.example.testj.service.impl.OrderLineServiceImpl;
import com.example.testj.service.mapper.GoodsMapper;
import com.example.testj.service.mapper.OrderLineMapper;
import com.example.testj.service.mapper.OrderMapper;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mapstruct.factory.Mappers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

import java.util.Optional;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
public class OrderLineServiceTest {
    @InjectMocks
    private OrderLineServiceImpl orderLineService;

    @Mock
    private OrderLineRepository orderLineRepository;

    @Mock
    private OrderService orderService;

    @Mock
    private GoodsService goodsService;

    @Spy
    private OrderLineMapper orderLineMapper = Mappers.getMapper(OrderLineMapper.class);

    @Spy
    private OrderMapper orderMapper = Mappers.getMapper(OrderMapper.class);

    @Spy
    private GoodsMapper goodsMapper = Mappers.getMapper(GoodsMapper.class);

    private static OrderLine orderLine;
    private static OrderDto orderDto;
    private static GoodsDto goodsDto;

    @BeforeAll
    static void init() {
        orderDto = new OrderDto(1L, "client 1", "20-20-2020", "address 1", null);
        goodsDto = new GoodsDto(1L, "product 1", 10.99);
        orderLine = new OrderLine(
                1L,
                new Order(orderDto.getId(), orderDto.getClient(), orderDto.getDate(), orderDto.getAddress(), null),
                new Goods(goodsDto.getId(), goodsDto.getName(), goodsDto.getPrice(), null),
                100
        );
    }

    @Test
    void testCreateOrderLine() {
        // given
        OrderLineRequestDto orderLineRequestDto = new OrderLineRequestDto(
                orderLine.getOrder().getId(),
                orderLine.getGoods().getId(),
                orderLine.getCount()
        );
        Long nextId = 2L;
        OrderLine result = new OrderLine(
               nextId,
               orderLine.getOrder(),
               orderLine.getGoods(),
               orderLine.getCount()
        );
        // when
        when(orderService.getOrder(any())).thenReturn(orderDto);
        when(goodsService.getGoods(any())).thenReturn(goodsDto);
        when(orderLineRepository.save(any(OrderLine.class))).thenReturn(result);
        OrderLineDto createdOrderLine = orderLineService.createOrderLine(orderLineRequestDto);
        // then
        assertEquals(result.getId(), createdOrderLine.getId());
        verify(orderLineRepository, times(1)).save(any(OrderLine.class));
    }

    @Test
    void testUpdateOrderLine() {
        // given
        Long id = 1L;
        int count = 10;
        orderLine.setId(id);
        OrderLine result = new OrderLine(
                orderLine.getId(),
                orderLine.getOrder(),
                orderLine.getGoods(),
                count
        );
        // when
        when(orderLineRepository.findById(id)).thenReturn(Optional.of(orderLine));
        when(orderLineRepository.save(any(OrderLine.class))).thenReturn(result);
        OrderLineDto updatedOrderLine = orderLineService.updateOrderLine(orderLine);
        // then
        assertEquals(count, updatedOrderLine.getCount());
        verify(orderLineRepository, times(1)).save(any(OrderLine.class));
    }

    @Test
    void testGetOrderLine() {
        // given
        Long id = 1L;
        // when
        when(orderLineRepository.findById(id)).thenReturn(Optional.of(orderLine));
        OrderLineDto orderLineDto = orderLineService.getOrderLine(id);
        // then
        assertEquals(id, orderLineDto.getId());
        verify(orderLineRepository, times(1)).findById(id);
    }

    @Test
    void testDeleteOrderLine() {
        // given
        Long id = 1L;
        // when
        when(orderLineRepository.findById(id)).thenReturn(Optional.of(orderLine));
        doNothing().when(orderLineRepository).deleteById(id);
        orderLineService.deleteOrderLine(id);
        // then
        verify(orderLineRepository, times(1)).deleteById(id);
    }
}
