import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import {
  HttpClient,
  HttpErrorResponse,
  HttpHeaders,
} from '@angular/common/http';
import { catchError, EMPTY, Observable } from 'rxjs';
import { PagedResponseModel } from '../model/paged-response.model';
import { Goods } from '../model/goods.model';

@Injectable({
  providedIn: 'root',
})
export class GoodsService {
  private readonly apiUrl = `${environment.API_ROOT}${environment.API_PREFIX}${environment.GOODS_URL}`;
  private page = 0;
  private limit = 10;

  constructor(private http: HttpClient) {}

  get(
    page = this.page,
    limit = this.limit
  ): Observable<PagedResponseModel<Goods>> {
    const url = `${this.apiUrl}`;

    const headers = new HttpHeaders({
      'Content-Type': 'application/json',
      'X-Page-Current': String(page),
      'X-Page-Size': String(limit),
    });
    return this.http.get<PagedResponseModel<Goods>>(url, { headers });
  }

  put(goods: Goods): Observable<Goods> {
    const url = `${this.apiUrl}/${goods.id}`;
    return this.http.put<Goods>(url, goods);
  }

  post(goods: Goods): Observable<Goods> {
    const url = this.apiUrl;
    return this.http.post<Goods>(url, goods);
  }

  delete(id: number) {
    const url = `${this.apiUrl}/${id}`;
    return this.http.delete(url).pipe(
      catchError((err: HttpErrorResponse) => {
        console.dir(err);
        return EMPTY;
      })
    );
  }
}
