import { HttpClient, HttpErrorResponse } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { catchError, EMPTY } from 'rxjs';
import { environment } from '../../../environments/environment';
import { OrderLine, OrderLineReq } from '../model/order.model';

@Injectable({
  providedIn: 'root',
})
export class OrderLineService {
  private readonly apiUrl = `${environment.API_ROOT}${environment.API_PREFIX}${environment.ORDER_LINE_URL}`;

  constructor(private http: HttpClient) {}

  put(ol: OrderLineReq) {
    const url = `${this.apiUrl}/${ol.id}`;
    return this.http.put<OrderLine>(url, ol);
  }

  post(ol: OrderLineReq) {
    const url = this.apiUrl;
    return this.http.post<OrderLine>(url, ol);
  }

  delete(id: number) {
    const url = `${this.apiUrl}/${id}`;
    return this.http.delete(url).pipe(
      catchError((err: HttpErrorResponse) => {
        console.dir(err);
        return EMPTY;
      })
    );
  }
}
