import { Component, EventEmitter, Input, Output } from '@angular/core';
import { NgbModal, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { takeUntil } from 'rxjs';
import { environment } from '../../../../../environments/environment';
import { AbstractBasicComponent } from '../../../../core/abstract/abstract-component';
import { Goods } from '../../../../core/model/goods.model';

const DEV = !environment.production;

@Component({
  selector: 'app-goods-edit-modal',
  templateUrl: './goods-edit-modal.component.html',
  styleUrl: './goods-edit-modal.component.scss',
})
export class GoodsEditModalComponent extends AbstractBasicComponent {
  @Input() product!: Goods;
  @Output() isUpdate = new EventEmitter<boolean>();

  modal: NgbModalRef | undefined;

  constructor(modalService: NgbModal) {
    super();

    modalService.activeInstances
      .pipe(takeUntil(this.destroy$))
      .subscribe((mls) => {
        this.modal = mls[mls.length - 1];
      });
  }

  goodsUpdate() {
    this.modal?.close();
    this.isUpdate.emit(true);
  }
}
