package com.example.testj.service.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.*;
import lombok.*;

import java.io.Serializable;

/**
 * DTO for {@link com.example.testj.domain.Goods}
 */
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GoodsDto implements Serializable {
    private Long id;

    @NotBlank
    private String name;

    @Positive
    private double price;
}