package com.example.testj.service.impl;

import com.example.testj.domain.Goods;
import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.repository.GoodsRepository;
import com.example.testj.service.GoodsService;
import com.example.testj.service.dto.GoodsDto;
import com.example.testj.service.mapper.GoodsMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PagedModel;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class GoodsServiceImpl implements GoodsService {
    private final GoodsRepository goodsRepository;
    private final GoodsMapper goodsMapper;

    @Override
    public PagedModel<GoodsDto> getPagedGoods(Integer page, Integer size, String sortBy, String sortDir) {
        return new PagedModel<>(goodsRepository
                .findAll(PageRequest.of(page, size, Sort.by(Sort.Direction.fromString(sortDir), sortBy)))
                .map(goodsMapper::toDto));
    }

    @Override
    public GoodsDto getGoods(Long id) throws ResourceNotFoundException {
        return goodsRepository.findById(id).map(goodsMapper::toDto).orElseThrow(ResourceNotFoundException::new);
    }

    @Override
    public GoodsDto createOrUpdateGoods(Goods goods) {
        return goodsMapper.toDto(this.goodsRepository.save(goods));
    }

    @Override
    public void deleteGoods(Long id) throws ResourceNotFoundException {
        this.goodsRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        this.goodsRepository.deleteById(id);
    }
}
