package com.example.testj.service.impl;

import com.example.testj.domain.Goods;
import com.example.testj.domain.Order;
import com.example.testj.domain.OrderLine;
import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.repository.OrderLineRepository;
import com.example.testj.service.GoodsService;
import com.example.testj.service.OrderLineService;
import com.example.testj.service.OrderService;
import com.example.testj.service.dto.OrderLineDto;
import com.example.testj.service.dto.OrderLineRequestDto;
import com.example.testj.service.mapper.GoodsMapper;
import com.example.testj.service.mapper.OrderLineMapper;
import com.example.testj.service.mapper.OrderMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class OrderLineServiceImpl implements OrderLineService {
    private final OrderLineRepository orderLineRepository;
    private final OrderLineMapper orderLineMapper;
    private final OrderService orderService;
    private final GoodsService goodsService;
    private final OrderMapper orderMapper;
    private final GoodsMapper goodsMapper;

    @Override
    public OrderLineDto createOrderLine(OrderLineRequestDto request) {
        OrderLine orderLine = new OrderLine();
        Order order = orderMapper.toEntity(orderService.getOrder(request.getOrderId()));
        orderLine.setOrder(order);
        Goods goods = goodsMapper.toEntity(goodsService.getGoods(request.getGoodsId()));
        orderLine.setGoods(goods);
        orderLine.setCount(request.getCount());

        return orderLineMapper.toDto(orderLineRepository.save(orderLine));
    }

    @Override
    public OrderLineDto updateOrderLineCount(Long id, int count) {
        OrderLine orderLine = orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        orderLine.setCount(count);
        return orderLineMapper.toDto(orderLineRepository.save(orderLine));
    }

    @Override
    public OrderLineDto getOrderLine(Long id) throws ResourceNotFoundException {
        return orderLineMapper.toDto(orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new));
    }

    @Override
    public void deleteOrderLine(Long id) {
        orderLineRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        orderLineRepository.deleteById(id);
    }
}
