package com.example.testj.repository;

import com.example.testj.domain.Goods;
import com.example.testj.domain.Order;
import com.example.testj.domain.OrderLine;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.boot.test.autoconfigure.orm.jpa.TestEntityManager;
import org.springframework.test.context.ActiveProfiles;

import java.util.List;
import java.util.stream.StreamSupport;

import static org.junit.jupiter.api.Assertions.*;

@DataJpaTest
@ActiveProfiles("test")
public class OrderLineRepositoryTest {
    @Autowired
    OrderLineRepository orderLineRepository;
    @Autowired
    TestEntityManager entityManager;

    @Test
    void testFindById() {
        // given
        Long id = 1L;
        // when
        OrderLine found = orderLineRepository.findById(id).orElse(null);
        // then
        assertNotNull(found);
        assertEquals(found.getId(), id);
    }

    @Test
    void testSave() {
        // given
        OrderLine orderLine = new OrderLine();
        Order order = new Order();
        order.setId(1L);
        Goods goods = new Goods();
        goods.setId(1L);
        orderLine.setOrder(order);
        orderLine.setGoods(goods);
        orderLine.setCount(100);
        // when
        orderLineRepository.save(orderLine);
        // then
        assertNotNull(orderLine.getId());
        assertEquals(entityManager.find(OrderLine.class, orderLine.getId()), orderLine);
    }

    @Test
    void testUpdate() {
        // given
        Long id = 1L;
        OrderLine orderLine = entityManager.find(OrderLine.class, id);
        orderLine.setCount(10);
        // when
        orderLineRepository.save(orderLine);
        // then
        assertEquals(entityManager.find(OrderLine.class, id), orderLine);
    }

    @Test
    void testDelete() {
        // given
        Long id = 1L;
        // when
        orderLineRepository.deleteById(id);
        // then
        assertNull(entityManager.find(OrderLine.class, id));
    }

    @Test
    void testFindAll() {
        // when
        List<OrderLine> orderLineList = StreamSupport.stream(orderLineRepository.findAll().spliterator(), false).toList();
        // then
        assertNotNull(orderLineList);
        assertEquals(100, orderLineList.size());
    }
}
