package com.example.testj.web.rest;

import com.example.testj.exception.ResourceNotFoundException;
import com.example.testj.service.GoodsService;
import com.example.testj.service.OrderLineService;
import com.example.testj.service.OrderService;
import com.example.testj.service.dto.OrderLineDto;
import com.example.testj.service.dto.OrderLineRequestDto;
import com.example.testj.service.dto.OrderLineUpdateRequestDto;
import com.example.testj.service.mapper.OrderLineMapper;
import jakarta.validation.Valid;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/order-line")
@CrossOrigin(origins = "http://localhost:4200")
@RequiredArgsConstructor
public class OrderLineController {
    private final OrderLineService orderLineService;
    private final OrderLineMapper orderLineMapper;
    private OrderService orderService;
    private GoodsService goodsService;

    @GetMapping("/{id}")
    public OrderLineDto get(@PathVariable Long id) {
        return orderLineService.getOrderLine(id);
    }

    @PostMapping
    @ResponseStatus(HttpStatus.CREATED)
    public OrderLineDto create(@Valid @RequestBody OrderLineRequestDto request) {
        return orderLineService.createOrderLine(request);
    }

    @PutMapping("/{id}")
    public OrderLineDto update(@PathVariable Long id, @Valid @RequestBody OrderLineUpdateRequestDto request) {
        OrderLineDto orderLineDto = orderLineService.getOrderLine(id);
        orderLineDto.setCount(request.getCount());
        return orderLineService.updateOrderLine(orderLineMapper.toEntity(orderLineDto));
    }

    @DeleteMapping("/{id}")
    public ResponseEntity<HttpStatus> delete(@PathVariable Long id) throws ResourceNotFoundException {
        try {
            orderLineService.deleteOrderLine(id);
            return new ResponseEntity<>(HttpStatus.OK);
        } catch (ResourceNotFoundException e) {
            return new ResponseEntity<>(HttpStatus.NOT_FOUND);
        }
    }

}
