import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import {
  NgbDatepickerModule,
  NgbNav,
  NgbNavContent,
  NgbNavItem,
  NgbNavItemRole,
  NgbNavLinkBase,
  NgbNavLinkButton,
  NgbNavOutlet,
  NgbPagination,
} from '@ng-bootstrap/ng-bootstrap';
import { FormErrorsComponent } from './form-errors/form-errors.component';
import { GoodsFormComponent } from './forms/goods-form/goods-form.component';
import { OrderFormComponent } from './forms/order-form/order-form.component';

@NgModule({
  declarations: [FormErrorsComponent, OrderFormComponent, GoodsFormComponent],
  imports: [
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    NgbNav,
    NgbNavContent,
    NgbNavItem,
    NgbNavItemRole,
    NgbNavLinkBase,
    NgbNavLinkButton,
    NgbNavOutlet,
    NgbDatepickerModule,
    NgbPagination,
  ],
  exports: [
    FormsModule,
    ReactiveFormsModule,
    NgbNav,
    NgbNavContent,
    NgbNavItem,
    NgbNavItemRole,
    NgbNavLinkBase,
    NgbNavLinkButton,
    NgbNavOutlet,
    NgbDatepickerModule,
    NgbPagination,
    FormErrorsComponent,
    OrderFormComponent,
    GoodsFormComponent,
  ],
})
export class SharedModule {}
