package com.example.testj.dto;

import java.io.Serializable;

/**
 * DTO for {@link com.example.testj.domain.Goods}
 */
public class GoodsDto implements Serializable {
    private final Long id;
    private final String name;
    private final Number price;

    public GoodsDto(Long id, String name, Number price) {
        this.id = id;
        this.name = name;
        this.price = price;
    }

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public Number getPrice() {
        return price;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "(" +
                "id = " + id + ", " +
                "name = " + name + ", " +
                "price = " + price + ")";
    }
}