package com.example.testj.web.rest;

import com.example.testj.domain.Goods;
import com.example.testj.repository.GoodsRepository;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@CrossOrigin(origins = "http://localhost:4200")
public class GoodsController {
    private final GoodsRepository goodsRepository;

    public GoodsController(GoodsRepository goodsRepository) {
        this.goodsRepository = goodsRepository;
    }

    @GetMapping("/goods")
    public List<Goods> goods() {
        return (List<Goods>) goodsRepository.findAll();
    }
}
