import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { environment } from '../../../environments/environment';
import { Order } from '../model/order.model';

@Injectable({
  providedIn: 'root',
})
export class OrderService {
  private readonly apiUrl = `${environment.API_ROOT}${environment.API_PREFIX}${environment.ORDER_URL}`;
  private page = 1;
  private limit = 10;

  constructor(private http: HttpClient) {}

  getOrders(): Observable<Order[]> {
    const url = `${this.apiUrl}`;

    const headers = new HttpHeaders({
      'Content-Type': 'application/json',
      Page: String(this.page),
      Limit: String(this.limit),
    });
    return this.http.get<Order[]>(url, { headers });
  }
}
