import {Component, OnInit} from '@angular/core';
import {Observable} from "rxjs";
import {Order} from "../../core/model/order.model";
import {OrderService} from "../../core/service/order.service";
import {AbstractBasicComponent} from "../../core/abstract/abstract-component";

@Component({
  selector: 'app-index-page',
  templateUrl: './index-page.component.html',
  styleUrl: './index-page.component.scss'
})
export class IndexPageComponent extends AbstractBasicComponent implements OnInit {

  protected orders$!: Observable<Order[]>;

  constructor(private orderService: OrderService) {
    super();

  }

  ngOnInit() {
    this.orders$ = this.orderService.getOrders();
  }
}
